<?php

require_once "conexion.php";

class ModeloPersonas{

	/*=============================================
	CREAR PERSONA
	=============================================*/

	static public function mdlIngresarPersona($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("INSERT INTO $tabla(nombres,codigo, documento, sexo, fechanacimiento, telefono, id_zona, direccion, email, universidad) VALUES (:nombres, :codigo, :documento, :sexo, :fechanacimiento, :telefono, :id_zona, :direccion, :email, :universidad)");

		$stmt->bindParam(":codigo", $datos["codigo"], PDO::PARAM_STR);
		$stmt->bindParam(":nombres", $datos["nombres"], PDO::PARAM_STR);
		$stmt->bindParam(":documento", $datos["documento"], PDO::PARAM_STR);
		$stmt->bindParam(":sexo", $datos["sexo"], PDO::PARAM_STR);
		$stmt->bindParam(":universidad", $datos["universidad"], PDO::PARAM_STR);
		$stmt->bindParam(":fechanacimiento", $datos["fecha_nacimiento"], PDO::PARAM_STR);
		$stmt->bindParam(":telefono", $datos["telefono"], PDO::PARAM_STR);
		$stmt->bindParam(":id_zona", $datos["idzona"], PDO::PARAM_STR);
		$stmt->bindParam(":direccion", $datos["nuevaDireccion"], PDO::PARAM_STR);
		$stmt->bindParam(":email", $datos["email"], PDO::PARAM_STR);

		


		if($stmt->execute()){

			return "ok";

		}else{

			return "error";
		
		}

		$stmt = null;

	}


	/*=============================================
	MOSTRAR CLIENTES
	=============================================*/

	static public function mdlMostrarPersonas($tabla, $item, $valor, $all = false){

		if($item != null){

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item");

			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);

			$stmt -> execute();

			if($all){
				$resultado = $stmt -> fetchAll(PDO::FETCH_ASSOC);
				return is_array($resultado) ? $resultado : array();
			}else {
				$resultado = $stmt -> fetch(PDO::FETCH_ASSOC);
				return $resultado ? $resultado : false;
			}

			

		}else{

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla");

			$stmt -> execute();

			$resultado = $stmt -> fetchAll(PDO::FETCH_ASSOC);
			return is_array($resultado) ? $resultado : array();

		}


		$stmt = null;

	}	


	static public function mdlMostrarPersonaServicio($tabla, $item, $valor){

		if($item != null){

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item AND estado in (0,1)");

			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);

			$stmt -> execute();

			$resultado = $stmt -> fetchAll(PDO::FETCH_ASSOC);
			return is_array($resultado) ? $resultado : array();

		}

		


		$stmt = null;

	}	



	static public function mdlMostrarPersona($tabla, $item, $valor){

		if($item != null){

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item");

			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);

			$stmt -> execute();

			$resultado = $stmt -> fetch(PDO::FETCH_ASSOC);
			return $resultado ? $resultado : false;

		}else{

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla");

			$stmt -> execute();

			$resultado = $stmt -> fetchAll(PDO::FETCH_ASSOC);
			return is_array($resultado) ? $resultado : array();

		}


		$stmt = null;

	}	
	
	

	/*=============================================
	EDITAR PERSONA
	=============================================*/

	static public function mdlEditarPersona($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET nombres = :nombres, codigo = :codigo, documento= :documento, sexo= :sexo, fechanacimiento= :fechanacimiento, telefono= :telefono, id_zona= :id_zona, direccion= :direccion, email= :email WHERE idpersona = :idpersona");

		$stmt->bindParam(":idpersona", $datos["idpersona"], PDO::PARAM_INT);
		$stmt->bindParam(":codigo", $datos["codigo"], PDO::PARAM_STR);
		$stmt->bindParam(":nombres", $datos["nombres"], PDO::PARAM_STR);
		$stmt->bindParam(":documento", $datos["documento"], PDO::PARAM_STR);
		$stmt->bindParam(":sexo", $datos["sexo"], PDO::PARAM_STR);
		$stmt->bindParam(":fechanacimiento", $datos["fecha_nacimiento"], PDO::PARAM_STR);
		$stmt->bindParam(":telefono", $datos["telefono"], PDO::PARAM_STR);
		$stmt->bindParam(":id_zona", $datos["idzona"], PDO::PARAM_INT);
		$stmt->bindParam(":direccion", $datos["direccion"], PDO::PARAM_STR);
		$stmt->bindParam(":email", $datos["email"], PDO::PARAM_STR);

		if($stmt->execute()){

			return "ok";

		}else{

			return "error";
		
		}

		$stmt = null;

	}

	/*=============================================
	ELIMINAR PERSONA
	=============================================*/

	static public function mdlEliminarPersona($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("DELETE FROM $tabla WHERE idpersona = :idpersona");

		$stmt -> bindParam(":idpersona", $datos, PDO::PARAM_INT);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}


		$stmt = null;

	}

	/*=============================================
	ACTUALIZAR CLIENTE
	=============================================*/

	static public function mdlActualizarCliente($tabla, $item1, $valor1, $valor){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = :$item1 WHERE id = :id");

		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		$stmt -> bindParam(":id", $valor, PDO::PARAM_STR);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}


		$stmt = null;

	}


		/*=============================================
	ACTUALIZAR ESTADO PERSONA
	=============================================*/

	static public function mdlActualizarEstadoPersona($tabla, $item1, $valor1, $item2, $valor2){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = :$item1 WHERE $item2 = :$item2");

		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item2, $valor2, PDO::PARAM_STR);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}


		$stmt = null;

	}

}